SELECT
    factors."idFactors" AS "id_domain",
    factors.name AS "domain",
    categories_nom035."Id" AS "id_category",
    categories_nom035."Description" AS "category",
    cat_norms."P1" AS "p1_domain",
    cat_norms."P2" AS "p2_domain",
    cat_norms."P3" AS "p3_domain",
    cat_norms."P4" AS "p4_domain",
    cat_norms.maxvalue AS "max_value_domain",
    SUM(answers.value) AS "total_value_domain",
    categories_nom035."P1" AS "p1_category",
    categories_nom035."P2" AS "p2_category",
    categories_nom035."P3" AS "p3_category",
    categories_nom035."P4" AS "p4_category",
    categories_nom035.maxvalue AS "max_value_category"
FROM "TST_RSPNCS" AS "answersEvaluated"
JOIN "TST_VLTNS" AS "evaluation"
    ON "answersEvaluated"."IdEvaluation" = evaluation."Id"
JOIN "ES_QSTNS" AS "questions"
    ON "answersEvaluated"."IdQuestion" = questions.idquestion
JOIN "ES_NSWRS" AS "answers"
    ON answers.id::text = "answersEvaluated"."Answer"
JOIN "ES_FCTRS" AS "factors"
    ON factors."idFactors"::text = questions."idFactors"::text
JOIN "RelCatFact_nom035" AS "relation_categories"
    ON relation_categories."IdFactor" = factors."idFactors"
JOIN "catCategory_nom035" AS "categories_nom035"
    ON relation_categories."IdCategory" = categories_nom035."Id"
JOIN "catNorms_nom035" AS "cat_norms"
    ON cat_norms."IdFactor" = factors."idFactors"
WHERE evaluation."IdProject" = 927
  AND evaluation."Status" = 4
  AND evaluation.deleted = false
  --AND evaluation."Id" IN (1685889, 1685890, 1685891)
  AND factors."idSurveyConfig" IN (465, 466)
GROUP BY
    factors."idFactors",
    factors.name,
    categories_nom035."Id",
    categories_nom035."Description",
    cat_norms."P1",
    cat_norms."P2",
    cat_norms."P3",
    cat_norms."P4",
    cat_norms.maxvalue,
    categories_nom035."P1",
    categories_nom035."P2",
    categories_nom035."P3",
    categories_nom035."P4",
    categories_nom035.maxvalue
ORDER BY
    factors.name;